<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Publico extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('apoyos_model');
    }

    // Función para obtener la lista de los niveles educativos
    public function niveles_get()
    {
        // Devolviendo el menú con un codigo 200 HTTP_OK
        $respuesta = $this->apoyos_model->obtenerNiveles();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Función para obtener la lista de las escuelas
    public function escuelas_get()
    {
        // Devolviendo el menú con un codigo 200 HTTP_OK
        $respuesta = $this->apoyos_model->obtenerEscuelas();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Función para obtener la lista de las colonias
    public function colonias_get()
    {
        // Devolviendo el menú con un codigo 200 HTTP_OK
        $respuesta = $this->apoyos_model->obtenerColonias();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Función para obtener la lista de las colonias
    public function tipos_documento_get()
    {
        // Devolviendo el menú con un codigo 200 HTTP_OK
        $respuesta = $this->apoyos_model->obtenerTiposDocumento();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }


    public function index_post()
    {
        // Devolviendo la respuesta con un codigo 200 HTTP_OK
        $post = (array) json_decode($this->post('apoyo'));
        $respuesta = $this->apoyos_model->guardarApoyo($post);
        $this->response($respuesta);
    }

    public function existecampo_post()
    {

        $respuesta = $this->apoyos_model->existeCampo($this->post()["campo"], $this->post()["valor"], $this->post()["nuevo"], $this->post()["idapoyo"]);

        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }




    public function informe_actividades_post()
    {
        $this->load->helper('registroapoyo');
        return imprimir($this->post());
        // $this->response($respuesta);
    }

    public function tipos_documentopag_post()
    {
        $this->load->model('documentos_model');
        $respuesta = $this->documentos_model->paginado($this->post());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    public function documentos_post()
    {   
        // Devolviendo el menú con un codigo 200 HTTP_OK
        $this->load->model('documentos_model');
        $respuesta = $this->documentos_model->obtenerDocumentos($this->post(0));
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    public function agregar_doc_post()
    {
        $this->load->model('documentos_model');
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->documentos_model->agregar_documento($post);
        $status = $respuesta['status'];
        $this->response($respuesta, $status);
    }
    public function actualizar_doc_post()
    {
        $this->load->model('documentos_model');
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->documentos_model->actualizar_documento($post);
        $status = $respuesta['status'];
        $this->response($respuesta, $status);
    }

}