<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Apoyos extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }
        $this->load->model('apoyos_model');
    }

    // Función para obtener la lista de los tipos de publico
    public function escuelas_get()
    {
        // Devolviendo el menú con un codigo 200 HTTP_OK
        $respuesta = $this->apoyos_model->obtenerEscuelas();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Función para obtener la lista de los tipos de propuestas
    public function apoyo_get($idapoyo = 0)
    {

        if ($idapoyo != 0)
        {
             // Devolviendo los propuestas con un codigo 200 HTTP_OK
            $respuesta = $this->apoyos_model->obtenerApoyo($idapoyo);
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }

        else
        {
            // Devolviendo el propuesta con un codigo 200 HTTP_OK
            $respuesta = $this->apoyos_model->obtenerApoyo($idapoyo);
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }
    }

    // Función para obtener la lista de los tipos de propuestas
    public function getAnexos_get($idapoyo = 0)
    {

        if ($idapoyo != 0)
        {
             // Devolviendo los propuestas con un codigo 200 HTTP_OK
            $respuesta = $this->apoyos_model->obtenerAnexos($idapoyo);
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }
    }

    public function index_post()
    {
        // Devolviendo la respuesta con un codigo 200 HTTP_OK
        $post = (array) json_decode($this->post('propuesta'));
        $respuesta = $this->apoyos_model->guardarPropuesta($post);
        $this->response($respuesta);
    }

    public function actualizar_apoyo_post()
    {
        // Devolviendo la respuesta con un codigo 200 HTTP_OK
        $post = (array) json_decode($this->post('apoyo'));
        $respuesta = $this->apoyos_model->guardarApoyo($post);
        $this->response($respuesta);
    }

    // Obtener el paginador
    public function paginado_post()
    {
        $this->load->model('apoyos_model');
        $respuesta = $this->apoyos_model->paginado($this->post());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

     // Función para actualizar el usuario
     public function index_put()
     {  
        // Obteniendo la respuesta de la funcion
        // $put = $this->put('propuesta');
        // $put = (array) json_decode($this->put('propuesta'));
        $respuesta = $this->apoyos_model->actualizarPropuesta($this->put());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
     }

     // Función para cambiar el estado del usuario
     public function cambiar_estado_put($idapoyo)
     {
        $respuesta = $this->apoyos_model->cambiarEstado($idapoyo);
        $this->response($respuesta["respuesta"], $respuesta['status']);
     }

     // Función para cambiar el estado del usuario
     public function cambiar_autorizado_post()
     {
        $respuesta = $this->apoyos_model->cambiarAutorizado($this->post());
        $this->response($respuesta["respuesta"], $respuesta['status']);
     }

     public function reporte_general_excel_post()
    {
        $this->load->helper("reportegeneral");
        reportegeneral_excel($this->post());
    }
    
    public function existeApoyo_get($idapoyo = 0)
    {
        if ($idapoyo == 0) {
            // Si no hay id, devuelves que no existe
            $this->response(['existe' => false], REST_Controller::HTTP_OK);
            return;
        }
    
        // Llama a tu modelo para obtener el apoyo
        $apoyo = $this->apoyos_model->ExisteApoyo($idapoyo);
    
        if ($apoyo && !empty($apoyo)) {
            // Apoyo encontrado
            $this->response(['existe' => true], REST_Controller::HTTP_OK);
        } else {
            // No se encontró apoyo
            $this->response(['existe' => false], REST_Controller::HTTP_OK);
        }
    }


}