<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Documentos extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }
        $this->load->model('documentos_model');
    }

    // Función para obtener la lista de los tipos de Documentos
    public function tiposdocumento_get($idtipo_documento = 0)
    {

        if ($idtipo_documento != 0)
        {
             // Devolviendo los usuarios con un codigo 200 HTTP_OK
            $respuesta = $this->documentos_model->obtenerTipoDocumento($idtipo_documento);
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }

        else
        {
            // Devolviendo el usuario con un codigo 200 HTTP_OK
            $respuesta = $this->documentos_model->obtenerTiposDocumento();
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }
    }

    public function index_post()
    {
                
        // Devolviendo la respuesta con un codigo 200 HTTP_OK
        $respuesta = $this->documentos_model->guardarTipoDocumento($this->post());

        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Obtener el paginador
    public function tiposdocumentopag_post()
    {
        $this->load->model('documentos_model');
        $respuesta = $this->documentos_model->paginado($this->post());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

     // Función para actualizar el tipo de documento
     public function index_put()
     {
 
        // Obteniendo la respuesta de la funcion
        $respuesta = $this->documentos_model->actualizarTipoDocumento($this->put());
 
        $this->response($respuesta["respuesta"], $respuesta["status"]);
     }

     // Función para cambiar el estado del tipo de documento
     public function cambiar_estado_put($idtipo_documento = 0)
     {
        $respuesta = $this->documentos_model->cambiarEstado($idtipo_documento);

        $this->response($respuesta["respuesta"], $respuesta['status']);
     }

}