<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Escuelas extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }
        $this->load->model('escuelas_model');
    }

    // Función para obtener la lista de escuelas
    public function escuela_get($idescuela = 0)
    {

        if ($idescuela != 0)
        {
             // Devolviendo las escuelas con un codigo 200 HTTP_OK
            $respuesta = $this->escuelas_model->obtenerEscuela($idescuela);
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }

        else
        {
            // Devolviendo las escuelas con un codigo 200 HTTP_OK
            $respuesta = $this->escuelas_model->obtenerEscuelas();
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }
    }

    public function index_post()
    {
                
        // Devolviendo la respuesta con un codigo 200 HTTP_OK
        $respuesta = $this->escuelas_model->guardarEscuela($this->post());

        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Obtener el paginador
    public function escuelaspag_post()
    {
        $this->load->model('escuelas_model');
        $respuesta = $this->escuelas_model->paginado($this->post());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

     // Función para actualizar la escuela
     public function index_put()
     {
 
        // Obteniendo la respuesta de la funcion
        $respuesta = $this->escuelas_model->actualizarEscuela($this->put());
 
        $this->response($respuesta["respuesta"], $respuesta["status"]);
     }

     // Función para cambiar el estado de la escuela
     public function cambiar_estado_put($idescuela = 0)
     {
        $respuesta = $this->escuelas_model->cambiarEstado($idescuela);

        $this->response($respuesta["respuesta"], $respuesta['status']);
     }

}