<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Propuestas extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }
        $this->load->model('propuestas_model');
    }

    // Función para obtener la lista de los tipos de publico
    public function tipospublico_get()
    {
        // Devolviendo el menú con un codigo 200 HTTP_OK
        $respuesta = $this->propuestas_model->obtenerTiposDePublico();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    public function obtenerTiposProyecto_post()
    {
                
        // Devolviendo la respuesta con un codigo 200 HTTP_OK
        $respuesta = $this->propuestas_model->obtenerTiposProyecto($this->post());
        $this->response($respuesta);
    }

    // Función para obtener la lista de los tipos de publico
    public function ambitos_get()
    {
        // Devolviendo el menú con un codigo 200 HTTP_OK
        $respuesta = $this->propuestas_model->obtenerAmbitos();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Función para obtener la lista de los tipos de publico
    public function disciplinas_get()
    {
        // Devolviendo el menú con un codigo 200 HTTP_OK
        $respuesta = $this->propuestas_model->obtenerDisciplinas();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Función para obtener la lista de los tipos de publico
    public function categorias_get()
    {
        // Devolviendo el menú con un codigo 200 HTTP_OK
        $respuesta = $this->propuestas_model->obtenerCategorias();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Función para obtener la lista de los tipos de propuestas
    public function propuesta_get($idpropuesta = 0)
    {

        if ($idpropuesta != 0)
        {
             // Devolviendo los propuestas con un codigo 200 HTTP_OK
            $respuesta = $this->propuestas_model->obtenerPropuesta($idpropuesta);
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }

        else
        {
            // Devolviendo el propuesta con un codigo 200 HTTP_OK
            $respuesta = $this->propuestas_model->obtenerPropuestas();
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }
    }

    // Función para obtener la lista de los tipos de propuestas
    public function getAnexos_get($idpropuesta = 0)
    {

        if ($idpropuesta != 0)
        {
             // Devolviendo los propuestas con un codigo 200 HTTP_OK
            $respuesta = $this->propuestas_model->obtenerAnexos($idpropuesta);
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }
    }

    public function index_post()
    {
        // Devolviendo la respuesta con un codigo 200 HTTP_OK
        $post = (array) json_decode($this->post('propuesta'));
        $respuesta = $this->propuestas_model->guardarPropuesta($post);
        $this->response($respuesta);
    }

    // Obtener el paginador
    public function paginado_post()
    {
        $this->load->model('propuestas_model');
        $respuesta = $this->propuestas_model->paginado($this->post());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

     // Función para actualizar el usuario
     public function index_put()
     {  
        // Obteniendo la respuesta de la funcion
        // $put = $this->put('propuesta');
        // $put = (array) json_decode($this->put('propuesta'));
        $respuesta = $this->propuestas_model->actualizarPropuesta($this->put());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
     }

     // Función para cambiar el estado del usuario
     public function cambiar_estado_put($idpropuesta)
     {
        $respuesta = $this->propuestas_model->cambiarEstado($idpropuesta);
        $this->response($respuesta["respuesta"], $respuesta['status']);
     }

}