<?php
class Apoyos_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('apoyos_model');
    }

    // Función para obtener la lista de niveles educativos
    public function obtenerNiveles()
    {
        $this->db->order_by('idnivel', 'ASC')->select('*')->from('niveles');
        $niveles = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $niveles,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }
    // Función para obtener la lista de escuelas
    public function obtenerEscuelas()
    {
        $this->db->order_by('escuela', 'ASC')->select('*')->from('escuelas_apoyo');
        $escuelas = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $escuelas,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }
    // Función para obtener la lista de colonias
    public function obtenerColonias()
    {
        $this->db->order_by('colonia', 'ASC')->select('*')->from('colonias');
        $colonias = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $colonias,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function obtenerTiposDocumento()
    {
        $this->db->select('*')->from('tipos_documento')->where('activo =', 1);
        $tipos_documento = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $tipos_documento,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    // Función para obtener el propuesta basado en el ID
    public function obtenerApoyo($idapoyo)
    {
        $this->db->select('*')->from('apoyos')->where('idapoyo =', $idapoyo);
        $apoyo = $this->db->get()->row_array();
        // print_r($idapoyo);
        $respuesta = array(
            'respuesta' => $apoyo,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;        
    }

    // Función para obtener los anexos basado en el ID
    public function obtenerAnexos($idapoyo)
    {
        $this->db->select('*')->from('anexos')->where('idapoyo =', $idapoyo);
        $propuesta = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $propuesta,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;        
    }

    public function existeCampo($campo, $valor, $nuevo, $idapoyo)
    {
        $valor_actual = "";

        if (!$nuevo) {
            $valor_actual = $this->db->get_where('apoyos', array('idapoyo' => $idapoyo, 'activo' => 1), 1)->row()->valor;
        }

        $query = $this->db->get_where('apoyos', array($campo => $valor, 'activo' => 1), 1);

        if($query->num_rows() > 0 )
        {
            if ($valor == $valor_actual) {
                $informacion = array(
                    'mensaje' => 'valor disponible',
                    'registrado' => false,
                    'result' => $query->result(),
                    'status' => 200,
                );

                $respuesta = array(
                    'respuesta' => $informacion,
                    'status' => REST_Controller::HTTP_OK
                );
        
                return $respuesta;

            } else {
                $informacion = array(
                    'mensaje' => 'El valor ya existe',
                    'registros' => $query->row(),
                    'registrado' => true,
                    'status' => 200,
                );

                $respuesta = array(
                    'respuesta' => $informacion,
                    'status' => REST_Controller::HTTP_OK
                );
        
                return $respuesta;
            }
        }

        else
        {
            $informacion = array(
                'mensaje' => 'valor disponible',
                'registros' => '',
                'registrado' => false,
                'status' => 200,
            );

            $respuesta = array(
                'respuesta' => $informacion,
                'status' => REST_Controller::HTTP_OK
            );
    
            return $respuesta;
        }
    }


    // Función para guardar el apoyo
    public function guardarApoyo($post)
    {
        // Comenzando la transacción
        $this->db->trans_begin();

        if($post['puesto'] == "OTRO"){
            $post['puesto'] = $post['otro_puesto'];
        }
        
    /*    if($post['nuevacolonia']!=''){
            
             $this->db->select('idcolonia')->from('colonias')->where('colonia =', $post['nuevacolonia']);
                $idcolonia = $this->db->get()->row_array();

            //$this->db->insert('colonias', array( 'cp'=>88000,'colonia'=> $post['nuevacolonia'], 'activo'=>1));
             $apoyo = array(
        'puesto' => $post['puesto'],
        'nombre' => $post['nombre'],
        'fecha_nac' => $post['fecha_nac'],
        'apellido_p' => $post['apellido_p'],
        'apellido_m' => $post['apellido_m'],
        'sexo' => $post['sexo'],
        'calle' => $post['calle'],
        'no_ext' => $post['no_ext'],
        'no_int' => $post['no_int'],
        'idcolonia' => $idcolonia,
        'telefono' => $post['telefono'],
        'correo' => $post['correo'],
        'curp' => $post['curp'],
        'categoria' => $post['categoria'],
        'sector' => $post['sector'],
        'rfc' => $post['rfc'],
        'homoclave' => $post['homoclave'],
        'banco' => $post['banco'],
        'cuenta_bancaria' => $post['cuenta_bancaria'],
        'clabe' => $post['clabe'],
        'idnivel' => $post['idnivel'],
        'idescuela' => $post['idescuela'],
        // 'grado' => $post['grado'],
        // 'asignatura' => $post['asignatura'],
        'turno' => $post['turno'],
        'zona_escolar' => $post['zona_escolar'],
        'sector_escolar' => $post['sector_escolar'],
        'telefono_escuela' => $post['telefono_escuela'],
        'clave_escuela' => $post['clave_escuela'],
        );
        }
        else{*/
            
        // Creando el array con los datos del apoyo
        $apoyo = array(
        'puesto' => $post['puesto'],
        'nombre' => $post['nombre'],
        'fecha_nac' => $post['fecha_nac'],
        'apellido_p' => $post['apellido_p'],
        'apellido_m' => $post['apellido_m'],
        'sexo' => $post['sexo'],
        'calle' => $post['calle'],
        'no_ext' => $post['no_ext'],
        'no_int' => $post['no_int'],
        'idcolonia' => $post['idcolonia'],
        'telefono' => $post['telefono'],
        'correo' => $post['correo'],
        'curp' => $post['curp'],
        'categoria' => $post['categoria'],
        'sector' => $post['sector'],
        'rfc' => $post['rfc'],
        'homoclave' => $post['homoclave'],
        'banco' => $post['banco'],
        'cuenta_bancaria' => $post['cuenta_bancaria'],
        'clabe' => $post['clabe'],
        'idnivel' => $post['idnivel'],
        'idescuela' => $post['idescuela'],
        // 'grado' => $post['grado'],
        // 'asignatura' => $post['asignatura'],
        'turno' => $post['turno'],
        'zona_escolar' => $post['zona_escolar'],
        'sector_escolar' => $post['sector_escolar'],
        'telefono_escuela' => $post['telefono_escuela'],
        'clave_escuela' => $post['clave_escuela'],
        );
    //    }
      //   print_r($apoyo);
      /*  if(!isset($apoyo['idescuela']) || $apoyo['idescuela'] == 0){
            $this->db->insert('escuelas2', array('idnivel' => $post['idnivel'], 'escuela' => $post['nueva_escuela'], 'clave' => $post['nueva_clave']));
            $apoyo['idescuela'] = $this->db->insert_id();
            $apoyo['escuela'] = $post['nueva_escuela'];
        }*/

        $this->db->select('*')->from('escuelas_apoyo')->where('idescuela =', $post['idescuela']);
        $escuela = $this->db->get()->row_array();
        if($post['nueva_escuela'] == ''){
            $apoyo['escuela'] = $escuela['escuela'];
        }
        
         
        $this->db->insert('apoyos', $apoyo);
        $id = $this->db->insert_id();

        $this->load->library('upload');
            $archivos=[];
            if (!empty($_FILES)) {
                $i=1;
                foreach($_FILES as $archivo){
                    //print_r($archivo);
                    $this->agregarFiles($id,'jpg|jpeg|png|pdf', $id.'/', $archivo,$i);
                    $i = $i + 1;
                }
            }

        if ($this->db->trans_status() === false) 
        {
            $respuesta = array(
                'respuesta' => 'Ocurrio un error al guardar los datos',
                'datos' => $apoyo,
                'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
            );
            return $respuesta;
        } 
        
        // De lo contrario
        else 
        {
            $this->db->trans_commit();
            $respuesta = array(
                'respuesta' => 'Propuesta agregada correctamente',
                'status' => REST_Controller::HTTP_OK,
                'idapoyo' => $id
            );
            return $respuesta;
        }
    }

    public function actualizarApoyo($post)
    {
        // Comenzando la transacción
        $this->db->trans_begin();
        // print_r($post);
        if($post['puesto'] == "OTRO"){
            $post['puesto'] = $post['otro_puesto'];
        }
        // Creando el array con los datos del apoyo
        $apoyo = array(
        'puesto' => $post['puesto'],
        'nombre' => $post['nombre'],
        'apellido_p' => $post['apellido_p'],
        'apellido_m' => $post['apellido_m'],
        'fecha_nac' => $post['fecha_nac'],
        'sexo' => $post['sexo'],
        'calle' => $post['calle'],
        'no_ext' => $post['no_ext'],
        'no_int' => $post['no_int'],
        'idcolonia' => $post['idcolonia'],
        'telefono' => $post['telefono'],
        'correo' => $post['correo'],
        'curp' => $post['curp'],
        'categoria' => $post['categoria'],
        'sector' => $post['sector'],
        'rfc' => $post['rfc'],
        'homoclave' => $post['homoclave'],
        'banco' => $post['banco'],
        'cuenta_bancaria' => $post['cuenta_bancaria'],
        'clabe' => $post['clabe'],
        'idnivel' => $post['idnivel'],
        'idescuela' => $post['idescuela'],
        'grado' => $post['grado'],
        'asignatura' => $post['asignatura'],
        'turno' => $post['turno'],
        'zona_escolar' => $post['zona_escolar'],
        'sector_escolar' => $post['sector_escolar'],
        'telefono_escuela' => $post['telefono_escuela'],
        'clave_escuela' => $post['clave_escuela'],
        );
        
        if(!isset($apoyo['idescuela']) || $apoyo['idescuela'] == 0){
            $this->db->insert('escuelas2', array('idnivel' => $post['idnivel'], 'escuela' => $post['nueva_escuela'], 'clave' => $post['nueva_clave']));
            $apoyo['idescuela'] = $this->db->insert_id();
        }

        $this->db->select('*')->from('escuelas2')->where('idescuela =', $post['idescuela']);
        $escuela = $this->db->get()->row_array();
        $apoyo['escuela'] = $escuela['escuela'];
        
        $this->db->where('idapoyo', $post['idapoyo']);
        $this->db->update('apoyos', $apoyo);
        $id = $post['idapoyo'];


        $this->load->library('upload');
            $archivos=[];
            if (!empty($_FILES)) {
                $i=1;
                foreach($_FILES as $archivo){
                    //print_r($archivo);
                    $this->agregarFiles($id,'jpg|jpeg|png|pdf', $id.'/', $archivo,$i);
                    $i = $i + 1;
                }
            }

        if ($this->db->trans_status() === false) 
        {
            $respuesta = array(
                'respuesta' => 'Ocurrio un error al guardar los datos',
                'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
            );
            return $respuesta;
        } 
        
        // De lo contrario
        else 
        {
            $this->db->trans_commit();
            $respuesta = array(
                'respuesta' => 'Propuesta agregada correctamente',
                'status' => REST_Controller::HTTP_OK,
                'idapoyo' => $id
            );
            return $respuesta;
        }
    }

    public function rechazarApoyo($post)
    {
        // Comenzando la transacción
        $this->db->trans_begin();
        // Creando el array con los datos del apoyo
        $apoyo = array(
        'comentarios' => $post['comentarios'],
        );
        
        $this->db->where('idapoyo', $post['idapoyo']);
        $this->db->update('apoyos', $apoyo);
   
        if ($this->db->trans_status() === false) 
        {
            $respuesta = array(
                'respuesta' => 'Ocurrio un error al guardar los datos',
                'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
            );
            return $respuesta;
        } 
        
        // De lo contrario
        else 
        {
            $this->db->trans_commit();
            $respuesta = array(
                'respuesta' => 'La Solicitud fue Rechazada',
                'status' => REST_Controller::HTTP_OK,
            );
            return $respuesta;
        }
    }

    public function cambiarEstado($idapoyo)
    {
        $this->db->trans_begin();
        $this->db->set('activo', 'NOT activo', FALSE)->where('idapoyo', $idapoyo)->update('apoyos');

        if($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();

            $respuesta = "Ocurrio un error, vuelva a intentar.";
            $status = REST_Controller::HTTP_INTERNAL_SERVER_ERROR;
        }

        else
        {
            $this->db->trans_commit();   
            $respuesta = "Estado actualizado correctamente";
            $status = REST_Controller::HTTP_OK;
        }    

        return array(
            'respuesta' =>  $respuesta,
            'status' => $status
        );
    }
    public function cambiarAutorizado($data)
    {
        $this->db->trans_begin();
        $this->db->set('autorizado', $data['estado'])->where('idapoyo', $data['id'])->update('apoyos');

        if($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();

            $respuesta = "Ocurrio un error, vuelva a intentar.";
            $status = REST_Controller::HTTP_INTERNAL_SERVER_ERROR;
        }

        else
        {
            $this->db->trans_commit();   
            $respuesta = "Cambio realizado correctamente";
            $status = REST_Controller::HTTP_OK;
        }    

        return array(
            'respuesta' =>  $respuesta,
            'status' => $status
        );
    }

    public function paginado($datos)
    {
        $this->load->library('paginado');
        $paginado = $this->paginado->paginar($datos, 'view_apoyosp');
        
        $respuesta = array(
            'respuesta' => $paginado,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }
    
    public function ExisteApoyo($idapoyo)
    {
        $this->db->select('idapoyo')->from('apoyos')->where('idapoyo', $idapoyo);
        $apoyo = $this->db->get()->row_array();
    
        // Devuelve true si se encontró el registro, false si no
        return !empty($apoyo);
    }

    
    

}
 