<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Colonias extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }
        $this->load->model('colonias_model');
    }

    // Función para obtener la lista de colonias
    public function colonia_get($idcolonia = 0)
    {

        if ($idcolonia != 0)
        {
             // Devolviendo las colonias con un codigo 200 HTTP_OK
            $respuesta = $this->colonias_model->obtenerColonia($idcolonia);
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }

        else
        {
            // Devolviendo las colonias con un codigo 200 HTTP_OK
            $respuesta = $this->colonias_model->obtenerColonias();
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }
    }

    public function agregar_colonia_post()
    {    
        // Devolviendo la respuesta con un codigo 200 HTTP_OK
        $respuesta = $this->colonias_model->agregar_colonia($this->post());
        $this->response($respuesta["mensaje"], $respuesta["status"]);
    }
    // Función para actualizar la colonia
    public function actualizar_colonia_post()
    {
       // Obteniendo la respuesta de la funcion
       $respuesta = $this->colonias_model->actualizar_colonia($this->post());
       $this->response($respuesta["mensaje"], $respuesta["status"]);
    }

    // Obtener el paginador
    public function coloniaspag_post()
    {
        $this->load->model('colonias_model');
        $respuesta = $this->colonias_model->paginado($this->post());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

     // Función para cambiar el estado de la colonia
     public function cambiar_estado_put($idcolonia = 0)
     {
        $respuesta = $this->colonias_model->cambiarEstado($idcolonia);
        $this->response($respuesta["respuesta"], $respuesta['status']);
     }

      // Obtener el paginador
    public function paginado_post()
    {
        $this->load->model('colonias_model');
        $respuesta = $this->colonias_model->paginado($this->post());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

}