<?php
class Colonias_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('colonias_model');
    }

     // Función para obtener la lista de colonias
     public function obtenerColonias()
     {
         $this->db->order_by('colonia', 'ASC')->select('*')->from('colonias');
         $colonias = $this->db->get()->result_array();
 
         $respuesta = array(
             'respuesta' => $colonias,
             'status' => REST_Controller::HTTP_OK
         );
 
         return $respuesta;
     }

    public function obtenerColonia($idcolonia)
    {
        $this->db->select('*')->from('colonias')->where('idcolonia = ', $idcolonia);
        $colonia = $this->db->get()->row_array();
        $respuesta = array(
            'respuesta' => $colonia,
            'status' => REST_Controller::HTTP_OK
        );
        return $respuesta;
    }

    public function paginado($datos)
    {
        $this->load->library('paginado');
        $paginado = $this->paginado->paginar($datos, 'colonias');
        
        $respuesta = array(
            'respuesta' => $paginado,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function cambiarEstado($idcolonia)
    {
        $this->db->trans_begin();
        $this->db->set('activo', 'NOT activo', FALSE)->where('idcolonia', $idcolonia)->update('colonias');

        if($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();

            $respuesta = "Ocurrio un error, vuelva a intentar.";
            $status = REST_Controller::HTTP_INTERNAL_SERVER_ERROR;
        }

        else
        {
            $this->db->trans_commit();   
            $respuesta = "Estado actualizado correctamente";
            $status = REST_Controller::HTTP_OK;
        }    

        return array(
            'respuesta' =>  $respuesta,
            'status' => $status
        );
    }

    public function agregar_colonia($post)
    {
        $this->load->library('upload');
        $this->db->trans_begin();
         
        $data = array(
            'colonia' => $post['colonia'],
            'activo'  => 1
        );

        $this->db->set($data);
        $this->db->insert('colonias');
          
        
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en insercion.',
                'error' => $this->db->error(),
                'status' => 409,
            );

        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;

    }

    public function actualizar_colonia($post)
    {
        $this->load->library('upload');
        $this->db->trans_begin();
        //  print_r($post);
        $data = array(
            'colonia' => $post['colonia']
        );

        $this->db->where('idcolonia', $post['idcolonia']);
        $this->db->set($data);
        $this->db->update('colonias');
          
        
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en insercion.',
                'error' => $this->db->error(),
                'status' => 409,
            );

        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;

    }
    
    public function agregarnuevacolonia($datos)
    {

        $colonia = $datos['colonia'];
        $cp = $datos['cp'];
        $activo = 1;

        $data = array(
            'colonia' => $colonia,
            'cp' => $cp,
            'activo' => $activo,
        );

        $this->db->trans_begin();
        $this->db->insert('colonias', $data);

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en insercion.',
                'error' => $this->db->error(),
                'status' => 409,
            );

        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


}
 