<?php
class Documentos_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('documentos_model');
    }

    // Función para obtener la lista de tipos de documentos
    public function obtenerTiposDeDocumento()
    {
        $this->db->select('*')->from('tipos_documento')->where('activo = ', 1);
        $tipos_documento = $this->db->get()->result_array();
        $respuesta = array(
            'respuesta' => $tipos_documento,
            'status' => REST_Controller::HTTP_OK
        );
        return $respuesta;
    }

    public function obtenerTipoDocumento($idtipo_documento)
    {
        $this->db->select('*')->from('tipos_documento')->where('idtipo_documento = ', $idtipo_documento);
        $tipos_documento = $this->db->get()->row_array();
        $respuesta = array(
            'respuesta' => $tipos_documento,
            'status' => REST_Controller::HTTP_OK
        );
        return $respuesta;
    }

    // Función para obtener la lista de documentos
    public function obtenerDocumentos($post)
    {
        $this->db->order_by('idtipo_documento ASC');
        $this->db->select('*')->from('documentos')->where('idapoyo = ', $post);
        $documentos = $this->db->get()->result_array();
        $respuesta = array(
            'respuesta' => $documentos,
            'status' => REST_Controller::HTTP_OK
        );
        return $respuesta;
    }

    public function agregar_documento($datos)
    {
        $this->load->library('upload');
        
        $this->db->trans_begin();
        // print_r($datos);
        $idusuario = $this->db->insert_id();
         $i = 1;
         foreach($datos as $dato){
             // print_r($dato->ruta);
             /////////FIRMA/////////////////
             $ruta = './assets/documentos'.'/'.$dato->idapoyo.'/';
             //$ruta = './assets/documentos'.'/'.$dato->idapoyo.'/';
             // $ruta = SERVIDOR.APP.'assets/documentos'.'/'.$dato['idapoyo'].'/';
         if(array_key_exists('documento'.$i, $_FILES)){
                 if (!is_dir($ruta)) {
                     mkdir($ruta, 0777, true);
                 }
                 if($dato->ruta != ''){
                     if(is_dir('./assets/documentos'.'/'.$dato->idapoyo.$dato->ruta)){
                         unlink('./assets/documentos'.'/'.$dato->idapoyo.$dato->ruta);
                     }
                    
                 }
                 //print_r($ruta);
                 $mi_archivo = 'documento'.$i;
                 $config['upload_path'] = './assets/documentos'.'/'.$dato->idapoyo;
                 $config['allowed_types'] = 'pdf';
                 $config['encrypt_name'] = true;
                 $config['max_size'] = '51200';
    
             $this->upload->initialize($config);
    
                 if (!$this->upload->do_upload($mi_archivo)) {
                     //*** ocurrio un error
                     $data['uploadError'] = $this->upload->display_errors();
                     echo $this->upload->display_errors();
                     return;
                 }
                 $data = array(
                     'idapoyo' => $dato->idapoyo,
                     'idtipo_documento' => $i,
                     'ruta' => '/'.$this->upload->data('file_name'),
                 );
                
                     $this->db->set($data);
                     $this->db->insert('documentos');
                 }
                
                 $data['uploadSuccess'] = $this->upload->data();
             $i++;
         }
        
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en insercion.',
                'error' => $this->db->error(),
                'status' => 409,
            );

        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;

    }

    public function actualizar_documento($datos)
    {
        $this->load->library('upload');
        
        $this->db->trans_begin();
        
        $idusuario = $this->db->insert_id();
         $i = 1;
         foreach($datos as $dato){
             /////////FIRMA/////////////////
             $ruta = './assets/documentos'.'/'.$dato->idapoyo.'/';
             // $ruta = SERVIDOR.APP.'assets/documentos'.'/'.$dato['idapoyo'].'/';
             if(array_key_exists('documento'.$i, $_FILES)){
                 if (!is_dir($ruta)) {
                     mkdir($ruta, 0777, true);
                 }
                 if($dato->ruta != ''){
                     if(file_exists('./assets/documentos'.'/'.$dato->idapoyo.$dato->ruta)){
                         unlink('./assets/documentos'.'/'.$dato->idapoyo.$dato->ruta);
                     }
                 }
                 //print_r($ruta);
                 $mi_archivo = 'documento'.$i;
                 $config['upload_path'] = './assets/documentos'.'/'.$dato->idapoyo;
                 $config['allowed_types'] = 'pdf';
                 $config['encrypt_name'] = true;
                 $config['max_size'] = '51200';
    
                 $this->upload->initialize($config);
    
                 if (!$this->upload->do_upload($mi_archivo)) {
                     //*** ocurrio un error
                     $data['uploadError'] = $this->upload->display_errors();
                     echo $this->upload->display_errors();
                     return;
                 }
                 $data = array(
                     'idapoyo' => $dato->idapoyo,
                     'idtipo_documento' => $i,
                     'ruta' => '/'.$this->upload->data('file_name'),
                 );

                
                 $this->db->where('idapoyo = ', $data['idapoyo']);
                 $this->db->where('idtipo_documento = ', $data['idtipo_documento']);
                 $this->db->where('iddocumento != ', $dato->iddocumento);
                 $this->db->delete('documentos');  
            
                 if($dato->iddocumento > 0){
                     $this->db->set($data);
                     $this->db->where('iddocumento', $dato->iddocumento);
                     $this->db->update('documentos', $data);
                 }else{
                     $this->db->set($data);
                     $this->db->insert('documentos');
                 }
                
                 $data['uploadSuccess'] = $this->upload->data();
             }$i++;
         }
        
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en insercion.',
                'error' => $this->db->error(),
                'status' => 409,
            );

        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;

    }

    public function subir_formato($datos)
    {
        $this->load->library('upload');
        
        $this->db->trans_begin();
        $idapoyo = [];
        $this->db->select('*')->from('apoyos')->where('curp = ', $datos['curp'])->where('activo = ', 1);
        $idapoyo = $this->db->get()->row_array();
        if($idapoyo == []){
            $respuesta = array(
                'respuesta' => 'El CURP ingresado no existe',
                'error' => $this->db->error(),
                'status' => 404,
            );
            return $respuesta;
        }
        $datos['ruta'] = $idapoyo['ruta_registro'];
        
        //$idusuario = $this->db->insert_id();
        $i = 1;
            /////////FIRMA/////////////////
            $ruta = './assets/documentos'.'/'.$idapoyo['idapoyo'].'/'.$datos['curp'].'/';
            // $ruta = SERVIDOR.APP.'assets/documentos'.'/'.$idapoyo['idapoyo'].'/';
            if(array_key_exists('documento'.$i, $_FILES)){
                if (!is_dir($ruta)) {
                    mkdir($ruta, 0777, true);
                }
                if($datos['ruta'] != ''){
                    if(file_exists('./assets/documentos'.'/'.$idapoyo['idapoyo'].'/'.$datos['curp'].$datos['ruta'])){
                        unlink('./assets/documentos'.'/'.$idapoyo['idapoyo'].'/'.$datos['curp'].$datos['ruta']);
                    }
                }
                // print_r('./assets/documentos'.'/'.$idapoyo['idapoyo'].'/'.$datos['curp']);
                $mi_archivo = 'documento'.$i;
                $config['upload_path'] = './assets/documentos'.'/'.$idapoyo['idapoyo'].'/'.$datos['curp'];
                $config['allowed_types'] = 'pdf';
                $config['encrypt_name'] = true;
                $config['max_size'] = '51200';
    
                $this->upload->initialize($config);
    
                if (!$this->upload->do_upload($mi_archivo)) {
                    //*** ocurrio un error
                    $data['uploadError'] = $this->upload->display_errors();
                    echo $this->upload->display_errors();
                    return;
                }
                $data = array(
                    'ruta_registro' => '/'.$this->upload->data('file_name'),
                );
                    $this->db->set($data);
                    $this->db->where('idapoyo', $idapoyo['idapoyo']);
                    $this->db->update('apoyos', $data);
                
                $data['uploadSuccess'] = $this->upload->data();
            }$i++;
        
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en insercion.',
                'error' => $this->db->error(),
                'status' => 409,
            );

        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'idapoyo' => $idapoyo['idapoyo'],
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;

    }

    public function paginado($datos)
    {
        $this->load->library('paginado');
        $paginado = $this->paginado->paginar($datos, 'tipos_documento');
        
        $respuesta = array(
            'respuesta' => $paginado,
            'status'    => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function cambiarEstado($idtipo_documento)
    {
        $this->db->trans_begin();
        $this->db->set('activo', 'NOT activo', FALSE)->where('idtipo_documento', $idtipo_documento)->update('tipos_documento');

        if($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();

            $respuesta = "Ocurrio un error, vuelva a intentar.";
            $status = REST_Controller::HTTP_INTERNAL_SERVER_ERROR;
        }

        else
        {
            $this->db->trans_commit();   
            $respuesta = "Estado actualizado correctamente";
            $status = REST_Controller::HTTP_OK;
        }    

        return array(
            'respuesta' =>  $respuesta,
            'status' => $status
        );
    }

    public function agregar_tipodocumento($post)
    {
        $this->load->library('upload');
        $this->db->trans_begin();
         
        $data = array(
            'tipo_documento' => $post['tipo_documento']
        );

        $this->db->set($data);
        $this->db->insert('tipos_documento');
          
        
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en insercion.',
                'error' => $this->db->error(),
                'status' => 409,
            );

        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;

    }

    public function actualizar_tipodocumento($post)
    {
        $this->load->library('upload');
        $this->db->trans_begin();
        //  print_r($post);
        $data = array(
            'tipo_documento' => $post['tipo_documento']
        );

        $this->db->where('idtipo_documento', $post['idtipo_documento']);
        $this->db->set($data);
        $this->db->update('tipos_documento');
          
        
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en insercion.',
                'error' => $this->db->error(),
                'status' => 409,
            );

        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;

    }


}
 