<?php
class Propuestas_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('propuestas_model');
    }

    // Función para obtener la lista de propuestas activos
    public function obtenerPropuestas()
    {
        $this->db->select('*')->from('propuestas')->where('activo = ', 1);
        $usuarios = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $propuestas,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }
    // Función para obtener el propuesta basado en el ID
    public function obtenerPropuesta($idpropuesta)
    {
        $this->db->select('*')->from('propuestas')->where('idpropuesta =', $idpropuesta);
        $propuesta = $this->db->get()->row_array();

        $respuesta = array(
            'respuesta' => $propuesta,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;        
    }

    // Función para obtener los anexos basado en el ID
    public function obtenerAnexos($idpropuesta)
    {
        $this->db->select('*')->from('anexos')->where('idpropuesta =', $idpropuesta);
        $propuesta = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $propuesta,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;        
    }

    public function obtenerTiposDePublico()
    {
        $this->db->select('*')->from('tipos_publico')->where('activo = ', 1);
        $propuestas = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $propuestas,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function obtenerTiposProyecto($post)
    {
        $idcategoria = $post['idcategoria'];
        $this->db->select('*')->from('tipos_proyectos')->where('activo = ', 1);
        $propuestas = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $propuestas,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function obtenerAmbitos()
    {
        $this->db->select('*')->from('ambitos')->where('activo = ', 1);
        $propuestas = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $propuestas,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function obtenerCategorias()
    {
        $this->db->select('*')->from('categorias')->where('activo = ', 1);
        $propuestas = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $propuestas,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function obtenerDisciplinas()
    {
        $this->db->select('*')->from('disciplinas_artisticas')->where('activo = ', 1);
        $propuestas = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $propuestas,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }


    // Función para guardar el propuesta
    public function guardarPropuesta($post)
    {
        // Comenzando la transacción
        $this->db->trans_begin();

        // Creando el array con los datos de la propuesta
        $propuesta = array(
        'nombre' => $post['nombre'],
        'edad' =>$post['edad'],
        'domicilio' =>$post['domicilio'],
        'telefono' =>$post['telefono'],
        'cel' =>$post['cel'],
        'correo' =>$post['correo'],
        'titulo' => $post['titulo'],
        'idcategoria' => $post['idcategoria'],
        'iddisciplina_artistica' =>$post['iddisciplina_artistica'],
        'idambito' =>$post['idambito'],
        'otro_ambito' =>$post['otro_ambito'],
        'idtipo_proyecto' => $post['idtipo_proyecto'],
        'idtipo_publico' => $post['idtipo_publico'],
        'otro_publico' =>$post['otro_publico'],
        'descripcion' => $post['descripcion'],
        'objetivos' => $post['objetivos'],
        'beneficios' => $post['beneficios'],
        'presupuesto' => $post['presupuesto'],
        'tipo_coinversion' => $post['tipo_coinversion'],
        'programacion_gastos' => $post['programacion_gastos'],
        'cronograma_actividades' => $post['cronograma_actividades'],
        'propuesta_difusion' => $post['propuesta_difusion'],
        'cronograma_acciones' => $post['cronograma_acciones'],
        'impacto_sustentabilidad' => $post['impacto_sustentabilidad'],
        'trayectoria_artistica' => $post['trayectoria_artistica'],
        );

        if($post['idcategoria'] == 3){
            $propuesta['iddisciplina_artistica'] = '';
            if($post['idambito'] != 7){
                $propuesta['otro_ambito'] == '';
            }
        }else{
            $propuesta['idambito'] = '';
            $propuesta['otro_ambito'] == '';
        }

        
        $this->db->insert('propuestas', $propuesta);
        $id = $this->db->insert_id();

        $this->load->library('upload');
            $archivos=[];
            if (!empty($_FILES)) {
                $i=1;
                foreach($_FILES as $archivo){
                    //print_r($archivo);
                    $this->agregarFiles($id,'jpg|jpeg|png|pdf', $id.'/', $archivo,$i);
                    $i = $i + 1;
                }
            }

        if ($this->db->trans_status() === false) 
        {
            $respuesta = array(
                'respuesta' => 'Ocurrio un error al guardar los datos',
                'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
            );
            return $respuesta;
        } 
        
        // De lo contrario
        else 
        {
            $this->db->trans_commit();
            $respuesta = array(
                'respuesta' => 'Propuesta agregada correctamente',
                'status' => REST_Controller::HTTP_OK,
            );
            return $respuesta;
        }
    }

    function agregarFiles($id,$extensiones,$ruta,$archivo,$i)
    {
        if (!is_dir(SERVIDOR . APP . 'assets/documentos/'.$ruta)) {
            mkdir(SERVIDOR . APP . 'assets/documentos/'.$ruta, 0777, true);
        }
        $config['upload_path'] = SERVIDOR . APP . 'assets/documentos/'.$ruta;
        $config['allowed_types'] = $extensiones;
        $config['max_size'] = '50000 KB';
        $config['encrypt_name'] = true;
        //$config['encrypt_name'] = true;
        $this->upload->initialize($config);
        if ($this->upload->do_upload('adjunto'.$i)) {
            $data = array("upload_data" => $this->upload->data());
            $nombre = $this->upload->data('file_name');
            $ext = $this->upload->data('file_ext');
            $anexo = array(
                'idpropuesta' => $id,
                'ruta' => $ruta.$nombre,
                );
            $this->db->insert('anexos', $anexo);
        }else{
            $error = array('error' => $this->upload->display_errors());
        }
        
        return [$nombre,$ext];
    }

    // Función para actualizar el propuesta
    public function actualizarPropuesta($post)
    {
       // Comenzando la transacción
       $this->db->trans_begin();
        // print_r($post);
       // Creando el array con los datos de la propuesta
       $propuesta = array(
        'nombre' => $post['nombre'],
        'edad' =>$post['edad'],
        'domicilio' =>$post['domicilio'],
        'telefono' =>$post['telefono'],
        'cel' =>$post['cel'],
        'correo' =>$post['correo'],
        'titulo' => $post['titulo'],
        'idcategoria' => $post['idcategoria'],
        'iddisciplina_artistica' =>$post['iddisciplina_artistica'],
        'idambito' =>$post['idambito'],
        'otro_ambito' =>$post['otro_ambito'],
        'idtipo_proyecto' => $post['idtipo_proyecto'],
        'idtipo_publico' => $post['idtipo_publico'],
        'descripcion' => $post['descripcion'],
        'objetivos' => $post['objetivos'],
        'beneficios' => $post['beneficios'],
        'presupuesto' => $post['presupuesto'],
        'tipo_coinversion' => $post['tipo_coinversion'],
        'programacion_gastos' => $post['programacion_gastos'],
        'cronograma_actividades' => $post['cronograma_actividades'],
        'propuesta_difusion' => $post['propuesta_difusion'],
        'cronograma_acciones' => $post['cronograma_acciones'],
        'impacto_sustentabilidad' => $post['impacto_sustentabilidad'],
        'trayectoria_artistica' => $post['trayectoria_artistica'],
        );

       if($post['idcategoria'] == 3){
        $propuesta['iddisciplina_artistica'] = '';
        if($post['idambito'] != 7){
            $propuesta['otro_ambito'] == '';
        }
        }else{
            $propuesta['idambito'] = '';
            $propuesta['otro_ambito'] == '';
        }
        
       $this->db->set($propuesta);
       $this->db->where('idpropuesta', $post['idpropuesta']);
       $this->db->update('propuestas');

    //    $id = $post['idpropuesta'];
    //    $this->load->library('upload');
    //         $archivos=[];
    //         if (!empty($_FILES)) {
    //             $i=1;
    //             foreach($_FILES as $archivo){
    //                 //print_r($archivo);
    //                 $this->agregarFiles($id,'jpg|jpeg|png|pdf', 'documentos/', $archivo,$i);
    //                 $i = $i + 1;
    //             }
    //         }

       if ($this->db->trans_status() === false) 
       {
           $respuesta = array(
               'respuesta' => 'Ocurrio un error al guardar los datos',
               'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
           );
           return $respuesta;
       } 
       
       // De lo contrario
       else 
       {
           $this->db->trans_commit();
           $respuesta = array(
               'respuesta' => 'Propuesta agregada correctamente',
               'status' => REST_Controller::HTTP_OK,
           );
           return $respuesta;
       }
    }

    public function cambiarEstado($idpropuesta)
    {
        $this->db->trans_begin();
        $this->db->set('activo', 'NOT activo', FALSE)->where('idpropuesta', $idpropuesta)->update('propuestas');

        if($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();

            $respuesta = "Ocurrio un error, vuelva a intentar.";
            $status = REST_Controller::HTTP_INTERNAL_SERVER_ERROR;
        }

        else
        {
            $this->db->trans_commit();   
            $respuesta = "Estado actualizado correctamente";
            $status = REST_Controller::HTTP_OK;
        }    

        return array(
            'respuesta' =>  $respuesta,
            'status' => $status
        );
    }

    public function paginado($datos)
    {
        $this->load->library('paginado');
        $paginado = $this->paginado->paginar($datos, 'propuestas');
        
        $respuesta = array(
            'respuesta' => $paginado,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

}
 